#!/bin/bash

set encoding=utf-8  
set fileencoding=utf-8  

# Install script 

# Identify the bundle path

# Try to get the USB bundle path on the fly
#bundle_path=`pkg-config libpcsclite --variable=usbdropdir`
bundle_path=

if [[ ${LANG:0:2} == "fr" ]] ;
then 
	INSTALLING="Installation"
	COPYING_INI_FILE_TO="Copie du fichier ini sur"
	COPIED_INI="Fichier ini copi"
	FAILED_TO_CPY_INI="Echec lors de la copie du fichier ini"
	COPYING_DR_BUNDLE="Copie de lensemble des pilotes sur"
	COPIED_DR_BUNDLE="Pilote(s) copi(s)"
	FAILED_TO_COPY_DRIVER_BUNGLE="Echec lors de la copie de(s) pilotes(s)"
	CREATING_SYMBOLIC_LINKS_FROM="Cration des liens symboliques  partir de"
	CREATED_SYMBOLIC_LINKS="Liens symboliques crs"
	INSTALLATION_COMPLETED="Installation termine."

	UNINSTALLING="Dsinstallation"
	REMOVING_INI_FILE_FROM="Suppression du fichier ini  partir de"
	REMOVED_INI_FILE="Fichier ini supprim"
	FAILED_TO_REMOVE_INI="Echec lors de la suppression du fichier ini"
	REMOVING_SYMBOLIC_LINKS_FROM="Suppression des liens symboliques  partir de"
	FAILED_TO_REMOVE="Echec lors de la suppression"
	SYMBOLIC_LINK="lien symbolique"
	REMOVED_SYMBOLIC_LINKS="Liens symboliques supprims"
	REMOVING_DR_BUNDLES_FROM="Retrait paquet (s ) de conducteur de"
	BUNDLE="paquet"
	REMOVED="Supprim"
	UNINSTALLATION_COMPLETED="Dsinstallation termine."

else 
	INSTALLING="Installing"
	COPYING_INI_FILE_TO="Copying ini file to"
	COPIED_INI="Copied the ini file"
	FAILED_TO_CPY_INI="Failed to copy the ini file"
	COPYING_DR_BUNDLE="Copying driver bundle(s) to"
	COPIED_DR_BUNDLE="Copied driver bundle(s)"
	FAILED_TO_COPY_DRIVER_BUNGLE="Failed to copy driver bundle(s)"
	CREATING_SYMBOLIC_LINKS_FROM="Creating symbolic links from"
	CREATED_SYMBOLIC_LINKS="Created symbolic links"
	INSTALLATION_COMPLETED="Installation completed."

	UNINSTALLING="Uninstalling"
	REMOVING_INI_FILE_FROM="Removing ini file from"
	REMOVED_INI_FILE="Removed the ini file"
	FAILED_TO_REMOVE_INI="Failed to remove the ini file"
	REMOVING_SYMBOLIC_LINKS_FROM="Removing symbolic links from"
	FAILED_TO_REMOVE="Failed to remove"
	SYMBOLIC_LINK="symbolic link"
	REMOVED_SYMBOLIC_LINKS="Removed symbolic links"
	REMOVING_DR_BUNDLES_FROM="Removing driver bundle(s) from"
	BUNDLE="bundle"
	REMOVED="Removed"
	UNINSTALLATION_COMPLETED="Uninstallation completed."

fi

# if the pkg-config has failed or it returned null
# then use the default locations for copying the bundle
if [ $? != 0 -o -z "$bundle_path" ]
then
	machine=`uname -m`
	distro=`cat /etc/issue`
	
	case "$distro" in

	# Check if the distribution is SUSE
	*[Ss][Uu][Ss][Ee]*)

		# Check if it is a 64-bit OS
		if [ $machine = "x86_64" ]
		then
			bundle_path="/usr/lib64/readers"
		else
			bundle_path="/usr/lib/readers"
		fi
		;;

    # Check if the distribution is RHEL
    *[Rr][Ee][Dd][\ ][Hh][Aa][Tt][\ ][Ee][Nn][Tt][Ee][Rr][Pp][Rr][Ii][Ss][Ee]*)
        # Check if it is a 64-bit OS
        if [ $machine = "x86_64" ]
        then
            bundle_path="/usr/lib64/pcsc/drivers"
        else
            bundle_path="/usr/lib/pcsc/drivers"
        fi
        ;;

	# Check if the distribution is Fedora
	*[Ff][Ee][Dd][Oo][Rr][Aa]*)

		# Check if it is a 64-bit OS
		if [ $machine = "x86_64" ]
		then
			bundle_path="/usr/lib64/pcsc/drivers"
		else
			bundle_path="/usr/lib/pcsc/drivers"
		fi
		;;

	# Check if the distribution is Ubuntu
	*[Uu][Bb][Uu][Nn][Tt][Uu]*)
		bundle_path="/usr/lib/pcsc/drivers"
		;;

	# Check if the distribution is Debian
	*[De][Ee][Bb][Ii][Aa][Nn]*)
		bundle_path="/usr/lib/pcsc/drivers"
		;;

	# Check if the distribution is PCLinuxOS
	*[Pp][Cc][Ll][Ii][Nn][Uu][Xx][Oo][Ss]*)
		bundle_path="/usr/lib/pcsc/drivers"
		;;
		
	# Check if the distribution is Mint
	*[Mm][Ii][Nn][Tt]*)
		bundle_path="/usr/lib/pcsc/drivers"
		;;
		

	# For other distributions
	*)
		bundle_path="/usr/local/pcsc/drivers"
		;;
	esac
fi

if [[ ${LANG:0:2} == "fr" ]] ;
then 
	echo "Installation..."
else
	echo "$INSTALLING..."
fi


# Installation of ini file
# Create the appropriate directory for placing the ini
mkdir -p /usr/local/identiv/ini

# Copy the ini file
if [[ ${LANG:0:2} == "fr" ]] ;
then 
	echo "Copie du fichier ini sur : /usr/local/identiv/ini"
else
	echo "$COPYING_INI_FILE_TO : /usr/local/identiv/ini"
fi



cp -f scmccid.ini /usr/local/identiv/ini/
if [ $? = 0 ]
then
	if [[ ${LANG:0:2} == "fr" ]] ;
	then 
		echo -e "Fichier ini copi\xc3\xa9"
	else
		echo "$COPIED_INI"
	fi

	
else
	if [[ ${LANG:0:2} == "fr" ]] ;
	then 
		echo "Echec lors de la copie du fichier ini"
	else
		echo "$FAILED_TO_CPY_INI"
	fi
	exit 1
fi

# Installation of the driver bundle(s)
# Create the appropriate directory for placing the bundle(s)
mkdir -p $bundle_path

# Copy the driver bundle(s)
if [[ ${LANG:0:2} == "fr" ]] ;
then 
	echo -e "Copie de l\x27ensemble des pilotes sur : $bundle_path"
else
	echo "$COPYING_DR_BUNDLE : $bundle_path"
fi

cp -rf ./proprietary/*.bundle $bundle_path
if [ $? = 0 ]
then
	if [[ ${LANG:0:2} == "fr" ]] ;
	then 
		echo -e "Pilote(s) copi\xc3\xa9(s)"
	else
		echo "$COPIED_DR_BUNDLE"
	fi
else
	if [[ ${LANG:0:2} == "fr" ]] ;
	then 
		echo "Echec lors de la copie de(s) pilotes(s)"
	else
		echo "$FAILED_TO_COPY_DRIVER_BUNGLE"
	fi
	exit 1
fi

# Create symbolic link from open source pcscd bundle path
if [ "$bundle_path" != "/usr/local/pcsc/drivers" ]
then               
	if [[ ${LANG:0:2} == "fr" ]] ;
	then 
		echo -e "Cr\xc3\xa9ation des liens symboliques  \xc3\xa0 partir de : /usr/local/pcsc/drivers"
	else
		echo "$CREATING_SYMBOLIC_LINKS_FROM : /usr/local/pcsc/drivers"
	fi

	mkdir -p /usr/local/pcsc/drivers

	cd ./proprietary
	for bundle in *.bundle
	do
		ln -sf $bundle_path/$bundle /usr/local/pcsc/drivers
	done
	cd ..

	if [[ ${LANG:0:2} == "fr" ]] ;
	then 
		echo -e "Liens symboliques cr\xc3\xa9\xc3\xa9s"
	else
		echo "$CREATED_SYMBOLIC_LINKS"
	fi
fi

if [ "$bundle_path" != "/usr/local/lib/pcsc/drivers" ]
then
	if [[ ${LANG:0:2} == "fr" ]] ;
	then 
		echo -e "Cr\xc3\xa9ation des liens symboliques  \xc3\xa0 partir de : /usr/local/lib/pcsc/drivers"
	else
		echo "$CREATING_SYMBOLIC_LINKS_FROM : /usr/local/lib/pcsc/drivers"
	fi
	
	mkdir -p /usr/local/lib/pcsc/drivers

	cd ./proprietary
	for bundle in *.bundle
	do
		ln -sf $bundle_path/$bundle /usr/local/lib/pcsc/drivers
	done
	cd ..

	if [[ ${LANG:0:2} == "fr" ]] ;
	then 
		echo -e "Liens symboliques cr\xc3\xa9\xc3\xa9s"
	else
		echo "$CREATED_SYMBOLIC_LINKS"
	fi	
fi


if [[ ${LANG:0:2} == "fr" ]] ;
then 
	echo -e "Installation termin\xc3\xa9e."
else
	echo "$INSTALLATION_COMPLETED"
fi



# Create uninstall script

echo "#!/bin/bash" > uninstall.sh
echo "# Uninstall script" >> uninstall.sh

echo "" >> uninstall.sh

echo "set encoding=utf-8" >> uninstall.sh  

if [[ ${LANG:0:2} == "fr" ]] ;
then 
	echo "echo -e \"D\xc3\xa9sinstallation...\"" >> uninstall.sh
else
	echo "echo \"$UNINSTALLING...\"" >> uninstall.sh
fi

echo "" >> uninstall.sh
echo "# Uninstallation of the ini file" >> uninstall.sh

if [[ ${LANG:0:2} == "fr" ]] ;
then 
	echo "echo -e \"Suppression du fichier ini \xc3\xa0 partir de : /usr/local/identiv/ini\"" >> uninstall.sh
else
	echo "echo \"$REMOVING_INI_FILE_FROM : /usr/local/identiv/ini\"" >> uninstall.sh
fi


echo "rm -f /usr/local/identiv/ini/scmccid.ini" >> uninstall.sh
echo "if [ \$? = 0 ]" >> uninstall.sh
echo "then" >> uninstall.sh      

if [[ ${LANG:0:2} == "fr" ]] ;
then 
	echo "	echo -e \"Fichier ini supprim\xc3\xa9\"" >> uninstall.sh
else
	echo "	echo \"$REMOVED_INI_FILE\"" >> uninstall.sh
fi


echo "else" >> uninstall.sh
if [[ ${LANG:0:2} == "fr" ]] ;
then 
	echo "	echo -e \"$FAILED_TO_REMOVE_INI\"" >> uninstall.sh
else
	echo "	echo \"$FAILED_TO_REMOVE_INI\"" >> uninstall.sh
fi

echo "	exit 1" >> uninstall.sh
echo "fi" >> uninstall.sh

echo "" >> uninstall.sh
echo "# Uninstallation of the driver bundles(s)" >> uninstall.sh

if [ "$bundle_path" != "/usr/local/pcsc/drivers" ]
then
echo "# Remove symbolic link from open source pcscd bundle path" >> uninstall.sh

if [[ ${LANG:0:2} == "fr" ]] ;
then 
	echo "echo -e \"Suppression des liens symboliques \xc3\xa0 partir de : /usr/local/pcsc/drivers\"" >> uninstall.sh
else
	echo "echo \"$REMOVING_SYMBOLIC_LINKS_FROM : /usr/local/pcsc/drivers\"" >> uninstall.sh
fi

cd ./proprietary
for bundle in *.bundle
do
echo "rm -rf /usr/local/pcsc/drivers/$bundle" >> ../uninstall.sh
echo "if [ \$? != 0 ]" >> ../uninstall.sh
echo "then" >> ../uninstall.sh
if [[ ${LANG:0:2} == "fr" ]] ;
then 
	echo "	echo -e \"$FAILED_TO_REMOVE /usr/local/pcsc/drivers/$bundle $SYMBOLIC_LINK\"" >> ../uninstall.sh
else
	echo "	echo \"$FAILED_TO_REMOVE /usr/local/pcsc/drivers/$bundle $SYMBOLIC_LINK\"" >> ../uninstall.sh
fi
echo "	exit 1" >> ../uninstall.sh
echo "fi" >> ../uninstall.sh
done
cd ..

if [[ ${LANG:0:2} == "fr" ]] ;
then 
	echo "echo -e \"Liens symboliques supprim\xc3\xa9s\"" >> uninstall.sh
else
	echo "echo \"$REMOVED_SYMBOLIC_LINKS\"" >> uninstall.sh
fi

fi

if [ "$bundle_path" != "/usr/local/lib/pcsc/drivers" ]
then
echo "# Remove symbolic link from open source pcscd bundle path" >> uninstall.sh

if [[ ${LANG:0:2} == "fr" ]] ;
then 
	echo "echo -e \"Suppression des liens symboliques \xc3\xa0 partir de : /usr/local/lib/pcsc/drivers\"" >> uninstall.sh
else
	echo "echo \"$REMOVING_SYMBOLIC_LINKS_FROM : /usr/local/lib/pcsc/drivers\"" >> uninstall.sh
fi

cd ./proprietary
for bundle in *.bundle
do
echo "rm -rf /usr/local/lib/pcsc/drivers/$bundle" >> ../uninstall.sh
echo "if [ \$? != 0 ]" >> ../uninstall.sh
echo "then" >> ../uninstall.sh

if [[ ${LANG:0:2} == "fr" ]] ;
then 
	echo "	echo -e \"$FAILED_TO_REMOVE /usr/local/lib/pcsc/drivers/$bundle $SYMBOLIC_LINK\"" >> ../uninstall.sh
else
	echo "	echo \"$FAILED_TO_REMOVE /usr/local/lib/pcsc/drivers/$bundle $SYMBOLIC_LINK\"" >> ../uninstall.sh
fi


echo "	exit 1" >> ../uninstall.sh
echo "fi" >> ../uninstall.sh
done
cd ..
if [[ ${LANG:0:2} == "fr" ]] ;
then 
	echo "echo -e \"Liens symboliques supprim\xc3\xa9s\"" >> uninstall.sh
else
	echo "echo \"$REMOVED_SYMBOLIC_LINKS\"" >> uninstall.sh
fi

fi

if [[ ${LANG:0:2} == "fr" ]] ;
then 
	echo "echo -e \"$REMOVING_DR_BUNDLES_FROM : $bundle_path\"" >> uninstall.sh
else
	echo "echo \"$REMOVING_DR_BUNDLES_FROM : $bundle_path\"" >> uninstall.sh
fi

cd ./proprietary

for bundle in *.bundle
do
echo "rm -rf $bundle_path/$bundle" >> ../uninstall.sh
echo "if [ \$? != 0 ]" >> ../uninstall.sh
echo "then" >> ../uninstall.sh

if [[ ${LANG:0:2} == "fr" ]] ;
then 
	echo "	echo -e \"$FAILED_TO_REMOVE $bundle_path/$bundle bundle\"" >> ../uninstall.sh
else
	echo "	echo \"$FAILED_TO_REMOVE $bundle_path/$bundle bundle\"" >> ../uninstall.sh
fi
echo "	exit 1" >> ../uninstall.sh
echo "fi" >> ../uninstall.sh

if [[ ${LANG:0:2} == "fr" ]] ;
then 
	echo "echo -e \"Supprim\xc3\xa9 $bundle\"" >> ../uninstall.sh
else
	echo "echo \"$REMOVED $bundle\"" >> ../uninstall.sh
fi

done

cd ..

echo "" >> uninstall.sh
if [[ ${LANG:0:2} == "fr" ]] ;
then 
	echo "echo -e \"D\xc3\xa9sinstallation termin\xc3\xa9e.\"" >> uninstall.sh
else
	echo "echo \"$UNINSTALLATION_COMPLETED\"" >> uninstall.sh
fi

echo "" >> uninstall.sh
echo "# Remove the uninstall script" >> uninstall.sh
echo "rm -f \$0"  >> uninstall.sh

chmod +x uninstall.sh

